// Scilab : 6.0.0
// OS: Windows 7, 64 bit
// Lab 5: To design a Lead Compensator by Root-Locus technique

clc ;
clear all;



s=%s;
G=syslin('c',1/s^2)     // Transfer Function of Un-compensated System
Gc=syslin('c',(s+1.15)/((s^2)*(s+4.2))) // Transfer Function of Compensated System
// Root - Locus of Un-Compensated System
figure(0)
clf, evans(G), xgrid(5, 1, 7)

// Root - Locus of Compensated System
figure(1)
clf, evans(Gc), xgrid(5, 1, 7)
replot([-4.5,-10,0.5,10])

// Step Response of Un-Compensated System
figure(2)
t= 0:0.1:100;
x=[csim('step',t,G/(1+G),[0;0;0])]';
plot2d(t',x),
xlabel("t", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");
xgrid(5, 1, 7)
xtitle( 'Step Response of Un-Compensated System');//, 'X axis', 'Y axis');
// Step Response of Compensated System
figure(3)
t= 0:0.1:100;
x=[csim('step',t,Gc/(1+Gc),[0;0;0])]';
plot2d(t',x),
xlabel("t", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");
xtitle( 'Step Response of Compensated System');//, 'X axis', 'Y axis');
xgrid(5, 1, 7)
